<?php

/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

class downloadModule {
	protected $registry;
	
	protected $image			= true;
	protected $thumb 			= true;
	protected $small				= false;
	protected $zip				= false;
	protected $imageoutput 	= false;
	
	private $fileid					= 0;
	private $groupid				= 0;
	private $filesize				= 0;
	
	protected $groupperm		= array();
	
	public function __construct($registry) {
		$this->registry = $registry;

		$this->groupperm['downloads_per_day']	 	=  $this->registry->userinfo['permissions']['dbtech_downloads_downloadsperday'];
		$this->groupperm['download_size_per_day'] 	=  $this->registry->userinfo['permissions']['dbtech_downloads_downloadsizeperday'];
		
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_module_download_construct')) ? eval($hook) : false;
	}
	
	public function load_file() {
		global $vbphrase;
		
		$this->image	= $this->registry->input->clean_gpc('g', 'image', TYPE_INT) == 1 ? true : false;
		$this->thumb 	= $this->registry->input->clean_gpc('g', 'thumb', TYPE_INT) == 1 ? true : false;
		$this->fileid		= $this->registry->input->clean_gpc('g', 'fileid', TYPE_INT);
		$this->zip		= $this->registry->input->clean_gpc('g', 'zip', TYPE_INT) == 1 ? true : false;
		$this->small	= $this->registry->input->clean_gpc('g', 'small', TYPE_INT) == 1 ? true : false; 
		
		if ($this->image == false && $this->thumb == false && $this->registry->userinfo['posts'] < $this->registry->options['dbtech_downloads_min_posts']) {
			$posterror = construct_phrase($vbphrase['dbtech_downloads_you_need_x_posts_to_download'], $this->registry->options['dbtech_downloads_min_posts']);
			
			standard_error($posterror);
		}
		
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_module_download_start')) ? eval($hook) : false;
		
		$file = $this->fetch_data();
		
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_module_download_preoutput')) ? eval($hook) : false;
		
		if (!empty($file)) {
			if ($this->imageoutput == true) {
				if (!$file['filename']) {
					if ($this->thumb == true) {
						$file['filename'] = 'thumb-' . $this->fileid . '.' . $file['ext'];
					} else {
						$file['filename'] = 'image.' . $file['ext']; 
					}
				}
				
				$this->image_output($file['data'], $file['filetype'], $file['ext'], $file['filename']);
			} else {
				$this->output_data($file['data'], $file['filename'], $file['filetype']);
			}
		} else {
			Downloads::throw_error('dbtech_downloads_file_not_found');
		}
	}
	
	protected function check_permissions($catid) {
		$category = $this->registry->db->query_first("
			SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_categories
			WHERE catid = " . intval($catid) . "
		");
		
		$permissions 	= unserialize($category['permissions']);
		$secondary		= explode(',', $this->registry->userinfo['membergroupids']);
		
		$candown = false;
		foreach ($secondary AS $ugid) {
			if (in_array($ugid, (array)$permissions['download'])) {
				$candown = true;
			}
		}
		
		if (!empty($permissions)) {
			if (!in_array($this->registry->userinfo['usergroupid'], $permissions['download']) && $candown == false) {
				print_no_permission();
			}
		}
	}
	
	protected function fetch_data() {
		$data = '';
		
		if ($this->fileid > 0) {
			if ($this->image == true) {
				$info = $this->fetch_info('image');
				
				$file 		= $info['file'];
				$group 	= $info['group'];
				
				$this->groupid = $info['group']['groupid'];
				
				$files 					= array();
				
				if (file_exists($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $file['fileid'] . '-' . $file['filename'])) {
					if ($this->small == false) {
						$files['data'] = file_get_contents($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $file['fileid'] . '-' . $file['filename']);
					} else {
						if (file_exists($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $file['fileid'] . '-thumb-' . $file['filename'])) {
							$files['data'] = file_get_contents($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $file['fileid'] . '-thumb-' . $file['filename']);
						} else {
							$files['data'] = file_get_contents($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $file['fileid'] . '-' . $file['filename']);
						}
					}
					
					$files['filetype']	= 'image/' . strtolower(end(explode('.', $file['filename'])));
					$files['ext']			= strtolower(end(explode('.', $file['filename'])));
				}
				
				$this->imageoutput = true;
			} else if ($this->thumb == true) {
				$info = $this->fetch_info('thumb');
				
				$file 		= $info['file'];
				$group 	= $info['group'];
				
				$this->groupid = $info['group']['groupid'];
				
				$files = array();
				
				if (!$group['image'] || !file_exists($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $group['groupid'] . '-thumb-' . $group['image'])) {
					$files['data'] 		= file_get_contents('dbtech/downloads/images/noimage.png');
					$files['filename'] 	= 'noimage.png';
					$files['filetype'] 	= 'image/png';
				} else {				
					$files['data'] 		= file_get_contents($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $group['groupid'] . '-thumb-' . $group['image']);
					$files['filetype']	= 'image/' . strtolower(end(explode('.', $group['image'])));
					$files['filename']	= ($group['image']) ? $group['image'] : $file['filename'];
					$files['ext']			= strtolower(end(explode('.', $group['image'])));
				}
			
				$this->imageoutput = true;
			} else {
				$info = $this->fetch_info('file');
				
				$file 		= $info['file'];
				$group 	= $info['group'];
				
				$this->groupid = $info['group']['groupid'];
				
				if (empty($info['file']) || empty($info['group'])) {
					Downloads::throw_error('dbtech_downloads_file_not_found');
				}
				
				$this->check_permissions($group['categoryid']);

				if (file_exists($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $file['fileid'] . '-' . $file['filename'])) {
					$files['data']		= file_get_contents($this->registry->options['dbtech_downloads_path_to_downloads'] . '/' . $file['fileid'] . '-' . $file['filename']);
					$files['filename']	= $file['filename'];
					$files['filetype']	= $file['filetype'];
				}
			}
			
			return $files;
		} else {
			return false;
		}
	}
	
	protected function fetch_info($type) {
		$file 		= array();
		$group 	= array();
		
		switch ($type) {
			
			case 'image':
				$file = $this->registry->db->query_first("
					SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_fileinfo
					WHERE fileid = " . intval($this->fileid) . "
				");
				
				$group = $this->registry->db->query_first("
					SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup
					WHERE groupid = " . intval($file['parentid']) . "
				");
			break;
			
			case 'thumb':
				$group = $this->registry->db->query_first("
					SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup
					WHERE groupid = " . intval($this->fileid) . "
				");
				
				$file = $this->registry->db->query_first("
					SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_fileinfo
					WHERE fileid = " . intval($group['image']) . "
				");
				
			break;
			
			case 'file':
				$file = $this->registry->db->query_first("
					SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_fileinfo
					WHERE fileid = " . intval($this->fileid) . "
				");
				
				$group = $this->registry->db->query_first("
					SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup
					WHERE groupid = " . intval($file['parentid']) . "
				");
				
			break;
		}
		
		return array('file' => $file, 'group' => $group);
	}
	
	protected function output_data($data, $filename, $filetype='', $zipinfo=array()) {
		require_once(DIR . '/includes/functions_file.php');
		
		if (!empty($zipinfo)) {
			$this->groupid = $zipinfo['groupid'];
			$this->fileid		= $zipinfo['fileid'];
		}
		
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_downloads_filegroup
			SET downloads = downloads + 1
			WHERE groupid = " . intval($this->groupid) . "
		");
		
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_downloads_fileinfo
			SET downloads = downloads + 1
			WHERE fileid = " . intval($this->fileid) . "
		");
		
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "user
			SET
				dbtech_downloads_downloads_today 		= dbtech_downloads_downloads_today + 1,
				dbtech_downloads_download_size_today	= dbtech_downloads_download_size_today + " . intval($this->filesize) . "
			WHERE userid = " . $this->registry->userinfo['userid'] . "
		");
		
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_module_download_output_noimage')) ? eval($hook) : false;
		
		file_download($data, $filename, $filetype);
	}
	
	private function image_output($data, $filetype, $fileext = '', $filename = '') {		
		require_once(DIR . '/includes/functions_file.php');
		
		$typesplit = explode('/', $filetype);
		
		if ($typesplit[0] != 'image' && $fileext) {
			$filetype = 'image/' . $fileext;
		}
		
		if (!$filename) {
			if ($this->thumb == true) {
				$filename = 'thumb-' . $this->fileid . '.' . $fileext;
			} else {
				$filename = 'image.' . $fileext;
			}
		} 

		if (!is_browser('ie')) {
			$filename = str_replace('"', '', $filename);
		}
		else
		{
			$filename = rawurlencode($filename);
		}
		
		header('Content-type: ' . $filetype);
		header('Content-Disposition: inline; filename="' . $filename . '"');
		
		echo $data;
		exit;
		
		
	}
}
?>